#include <Winsock2.h>
#include <windows.h>
#include "scripts.h"
#include <stdarg.h>
#include <algorithm>
#include "engine.h"
#include "gmmain.h"
#include "GameSpy.h"
#include "time.h"
#include "plugin.h"

int GameSpy::ListenSocket = 0;
struct sockaddr_in GameSpy::ClientAddress, GameSpy::ServerAddress, GameSpy::MasterAddress1, GameSpy::MasterAddress2;
unsigned short GameSpy::QueryPort = 0;
time_t GameSpy::LastHeartbeat = 0;
int GameSpy::ClientAddressLength;
int GameSpy::PlayerJoinTime[127];

void GameSpy::StartUp()
{
	char Buf[32];										
	InitListen(Long2IP(The_Game()->IP, Buf, 32), Config::ListenPort);
	printf("[GameSpy Support SSGM Plugin] Loaded on %s:%d\n", Long2IP(The_Game()->IP, Buf, 32),Config::ListenPort);
}

int GameSpy::InitListen(const char *IP, unsigned short Port)
{
	QueryPort = Port;
	struct hostent *HostInfo;
	HostInfo = gethostbyname("92.242.144.2"); //");
	if (HostInfo != NULL)
	{
		MasterAddress1.sin_family = HostInfo->h_addrtype;
		memcpy((char *) &MasterAddress1.sin_addr.s_addr, HostInfo->h_addr_list[0], HostInfo->h_length);
		MasterAddress1.sin_port = htons(27900);
	}
	HostInfo = gethostbyname("master.gamespy.com");
	if (HostInfo != NULL)
	{
		MasterAddress2.sin_family = HostInfo->h_addrtype;
		memcpy((char *) &MasterAddress2.sin_addr.s_addr, HostInfo->h_addr_list[0], HostInfo->h_length);
		MasterAddress2.sin_port = htons(27900);
	}
	ListenSocket = socket(AF_INET, SOCK_DGRAM, 0);
	if (ListenSocket < 0)
	{
		printf("Error: Cannot create listen socket.\n");
	}
	HostInfo = gethostbyname(IP);
	if (HostInfo != NULL)
	{
		ServerAddress.sin_family = AF_INET;
		memcpy((char *) &ServerAddress.sin_addr.s_addr, HostInfo->h_addr_list[0], HostInfo->h_length);
		ServerAddress.sin_port = htons(Port);

		if (bind(ListenSocket,(struct sockaddr *) &ServerAddress,sizeof(ServerAddress)) < 0)
		{
			printf("Error: Cannot bind listen port.\n");
		}
		listen(ListenSocket, 5);
		CreateThread(NULL, NULL, ListenThread, NULL, NULL, NULL);
	}
	return 1;
}

DWORD WINAPI GameSpy::ListenThread(LPVOID param)
{
	char Get[4096];
	char Send[20480];
	char Tmp[256];
	int x = 0;

	DoHeartBeat();

	for(;;)
	{
		x++;
		ClientAddressLength = sizeof(ClientAddress);
		memset(Get, 0x0, 4096);
		memset(Send, 0x0, 20480);
		memset(Tmp, 0x0, 256);
		if (recvfrom(ListenSocket, Get, 4095, 0,(struct sockaddr *) &ClientAddress,&ClientAddressLength) < 0)
		{
		//	printf("Error: Input/Ouput failure.\n");
		}
		if (!strcmp(Get,"\\basic\\"))
		{
			char *Data = GetBasic();
			sprintf(Send,"%s\\final\\\\queryid\\%d.1",Data,x);
			delete []Data;
		}
		else if (!strcmp(Get,"\\info\\"))
		{
			char *Data = GetInfo();
			sprintf(Send,"%s\\final\\\\queryid\\%d.1",Data,x);
			delete []Data;
		}
		else if (!strcmp(Get,"\\rules\\"))
		{
			char *Data = GetRules();
			sprintf(Send,"%s\\final\\\\queryid\\%d.1",Data,x);
			delete []Data;
		}
		else if (!strcmp(Get,"\\players\\"))
		{
			char *Data = GetPlayers(Send,&x);
			sprintf(Send,"%s\\queryid\\%d.1",Data,x);
			delete []Data;
		}
		else if (!strcmp(Get,"\\status\\"))
		{
			char *Data = GetBasic();
			sprintf(Send,"%s",Data);
			delete []Data;
			Data = GetInfo();
			sprintf(Send,"%s%s",Send,Data);
			delete []Data;
			Data = GetRules();
			sprintf(Send,"%s%s",Send,Data);
			delete []Data;
			Data = GetPlayers(Send,&x);
			sprintf(Send,"%s\\final\\\\queryid\\%d.1",Data,x);
			delete []Data;
		}
		else if (sscanf(Get,"\\echo\\%[^\r\n\0]",Tmp))
		{
			sprintf(Send,"\\echo\\%s\\final\\\\queryid\\%d.1",Tmp,x);
		}

		if (strlen(Send) > 0)
		{
			if (sendto(ListenSocket, Send, strlen(Send) + 1, 0,(struct sockaddr *) &ClientAddress,sizeof(ClientAddress)) < 0)
			{
				printf("[GameSpy Support SSGM Plugin] Error: Data send failure.\n");
				break;
			}
		}
		Sleep(10);
	}
	return 0;
}

char *GameSpy::GetBasic()
{
	char *Data = new char[4096];
	memset(Data, 0x0, 4096);
	sprintf(Data,"\\gamename\\ccrenegade\\gamever\\838");
	return Data;
}

char *GameSpy::GetInfo()
{
	char *Data = new char[4096];
	memset(Data, 0x0, 4096);
	if (Config::CustomGameTitle == "0")
	{
		sprintf(Data, "%s\\hostname\\\%s", Data, Config::GameTitle.c_str());	
	}
	else
	{
		sprintf(Data, "%s\\hostname\\\%s", Data, Config::CustomGameTitle.c_str());
	}

	sprintf(Data, "%s\\hostport\\%d", Data, The_Game()->Port);
	sprintf(Data, "%s\\mapname\\%s", Data, The_Game()->MapName);

	if (Config::ShowGameMode)
	{
		sprintf(Data, "%s\\gametype\\%s", Data, Config::GameMode.c_str());
	}
	sprintf(Data, "%s\\numplayers\\%d", Data, The_Game()->CurrentPlayers);
	sprintf(Data, "%s\\maxplayers\\%d", Data, Config::MaxPlayers ? Config::MaxPlayers : The_Game()->MaxPlayers);
	return Data;
}

char *GameSpy::GetRules()
{
	char *Data = new char[8192];
		
	char TimeStr[128];
	FormatTime((time_t)The_Game()->TimeRemaining_Seconds, "%H:%M:%S", TimeStr, 256);

	memset(Data, 0x0, 8192);
	sprintf(Data,"\\DED\\1");

	if (Config::ShowDriverGunner)
	{
		sprintf(Data,"%s\\Driver Gunner\\%s",Data,The_Game()->DriverIsAlwaysGunner ? "On" : "Off");
	}
	if (Config::ShowTeamChanging)
	{
		sprintf(Data,"%s\\Team Changing\\%s",Data,The_Game()->IsTeamChangingAllowed ? "On" : "Off");
	}
	if (Config::ShowFriendlyFire)
	{
		sprintf(Data,"%s\\Friendly Fire\\%s",Data,The_Game()->IsFriendlyFirePermitted ? "On" : "Off");
	}
	if (Config::ShowCredits)
	{
		sprintf(Data,"%s\\Start Credits\\%d",Data,The_Cnc_Game()->StartingCredits);
	}
	if (Config::ShowTimeLeft)
	{
		sprintf(Data,"%s\\TimeLeft\\%s",Data, TimeStr);
	}
	if (Config::ShowPedestal)
	{
		sprintf(Data,"%s\\Pedestal Beacon\\%s",Data,The_Cnc_Game()->BeaconPlacementEndsGame ? "On" : "Off");
	}
	
	int z;
	for( z = 0;; z++)
	{
		std::string tmp = Config::ExtraStringList[z];
		const char* x = tmp.c_str();
		if( *x != 0)
		{
			sprintf(Data, "%s\\%s", Data, x);
		}
		else
		{
			break;
		}
	}
	if (Config::ShowRotation)
	{
		for(int i = 0;; i++)
		{
			const char *x = The_Game()->MapList[i];
			if( *x != 0)
			{
				sprintf(Data,"%s\\Map%02d\\%s", Data, i, x);
			}
			else
			{
				break;
			}
		}
	}
	return Data;
}

char *GameSpy::GetPlayers(const char *Send, int *x)
{
	char *Data = new char[20480];
	memset(Data, 0x0, 20480);
	sprintf(Data,"%s",Send);
	int i = 0;
	for (GenericSLNode* PlayerIter = PlayerList->HeadNode; (PlayerIter != NULL); PlayerIter = PlayerIter->NodeNext)
	{
		cPlayer *p = (cPlayer *)PlayerIter->NodeData;

		if (p->IsActive)
		{
			char TimeStr[128];
			if ( Config::UseTotalPlayerTime )
			{
				FormatTime(time(NULL) - GameSpy::GetJoinTime(p->PlayerId), "%H:%M:%S", TimeStr, 256);
			}
			else
			{
				FormatTime((time_t)p->GameTime, "%H:%M:%S", TimeStr, 256);
			}
			sprintf(Data,"%s\\player_%d\\%ls\\score_%d\\%d\\kills_%d\\%d\\deaths_%d\\%d\\time_%d\\%s\\ping_%d\\%d\\team_%d\\%ls",Data,i,p->PlayerName,i,(int)Get_Score(p->PlayerId),i, (int)Get_Kills(p->PlayerId),i,(int)Get_Deaths(p->PlayerId),i,TimeStr,i,Get_Ping(p->PlayerId),i,Get_Wide_Team_Name(Get_Team(p->PlayerId)));
			i++;
		}
	}
	return Data;
}

void GameSpy::DoHeartBeat()
{
	char Send[4096];
	memset(Send, 0x0, 4096);
	sprintf(Send,"\\heartbeat\\%d\\gamename\\ccrenegade",Config::ListenPort);

	if (sendto(ListenSocket, Send, strlen(Send) + 1, 0,(struct sockaddr *) &MasterAddress1,sizeof(MasterAddress1)) < 0)
	{
		printf("[GameSpy Support SSGM Plugin] Error: Heartbeat failure.\n");
	}
	if (sendto(ListenSocket, Send, strlen(Send) + 1, 0,(struct sockaddr *) &MasterAddress2,sizeof(MasterAddress2)) < 0)
	{
		printf("[GameSpy Support SSGM Plugin] Error: Heartbeat failure.\n");
	}
}

const char *Long2IP(unsigned int longip, char *buffer, int size)
{
	sprintf_s(buffer, size, "%d.%d.%d.%d", 0xFF & longip, (0xFF00 & longip) >> 8, (0xFF0000 & longip) >> 16, ((0xFF000000 & longip) >> 24));
	return buffer;
}

void FormatTime(time_t t, const char *Format, char *buffer, int Length)
{
	tm* time = new tm;
	memset((void*)time, 0x0, sizeof(time));
	time->tm_hour = t / 3600;
	time->tm_min  = (t % 3600) / 60;
	time->tm_sec = t % 60;
	strftime(buffer, Length, Format, time);
	delete time;

}

void GameSpy::SetJoinTime(int ID, int value)
{
	GameSpy::PlayerJoinTime[ID] = value;
}

int GameSpy::GetJoinTime(int ID)
{
	return GameSpy::PlayerJoinTime[ID];
}